import json

from abc import ABCMeta,abstractmethod


class BaseDataLoader(metaclass=ABCMeta):
    @abstractmethod
    def step(self):
        """Takes one timestep and returns a data sample/batch
        """
        pass
    
    @abstractmethod
    def reset(self):
        """Resets the dataloader state
        """
        pass

    @abstractmethod
    def init(self,args):
        """Inits dataset with config
        """
        pass

    def load_config_file(self,config_path):
        with open(config_path) as f:
            config=json.loads(f.read())
        self.config=config
    
    def get_config(self):
        return self.config